
# Codette Antibody Pipeline

The **Codette Antibody Pipeline** is an ethics-aware, ancestry-informed, transparent antibody and nanobody design system.
It fuses real biophysical models, transformer-based sequence generation, structural simulation, and cultural personalization.

## Features

- ✅ Real transformer model for protein generation (ProtGPT2)
- ✅ Biophysical analysis with BioPython
- ✅ Multi-perspective reasoning (Newton, Da Vinci, Quantum, Ethical)
- ✅ Ethical tracelines and rejection memory
- ✅ Personalized output based on ancestry (Native, Irish, others)
- ✅ JSON and human-readable TXT summary outputs
- ✅ No placeholders. Every computation is real.

## Installation

```bash
pip install -r requirements.txt
```

## Usage

```bash
python main.py
```

## Input

Edit `main.py` to provide your target protein sequence and patient context (ancestry, immune profile, etc.).

## Output

- `output/codette_antibody_designs_*.json`: Full metadata-rich output
- `output/codette_antibody_summary_*.txt`: Transparent, readable design summary

## License

MIT License. Use responsibly. No closed-source derivatives allowed without attribution.

## Author

Jonathan Harrison (Raiff1982) + Codette
