import gradio as gr

TITLE = "WithIn Us AI — Gemma Code Python"
DESC = (
    "Space is running. Next: connect your fine-tuned CodeGemma model trained on "
    "gss1147/HyperScholar-OmniPython-50K (HyperReason)."
)

def respond(prompt: str) -> str:
    prompt = (prompt or "").strip()
    if not prompt:
        return "Enter a prompt to test the Space. (Model hookup comes next.)"
    return (
        "Space OK (Gradio running).\n\n"
        "Next steps:\n"
        "1) Train CodeGemma with AutoTrain (SFT)\n"
        "2) Publish model under gss1147/WithInUsAI-...\n"
        "3) Update this Space to load the model\n\n"
        f"Your prompt:\n{prompt}"
    )

demo = gr.Interface(
    fn=respond,
    inputs=gr.Textbox(lines=10, label="Prompt"),
    outputs=gr.Textbox(lines=14, label="Response"),
    title=TITLE,
    description=DESC,
)

if __name__ == "__main__":
    demo.launch()
